/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.eui;

import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.JDMInput;
import ibm.nways.jdm.eui.StringInput;
import java.awt.TextComponent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;

public class NumericInput
extends StringInput
implements JDMInput,
FocusListener {
    public static final int MAX8SIGNED = 127;
    public static final int MIN8SIGNED = -128;
    public static final int MAX8UNSIGNED = 255;
    public static final int MIN8UNSIGNED = 0;
    public static final int MAX16SIGNED = Short.MAX_VALUE;
    public static final int MIN16SIGNED = Short.MIN_VALUE;
    public static final int MAX16UNSIGNED = 65536;
    public static final int MIN16UNSIGNED = 0;
    public static final int MAX32SIGNED = Integer.MAX_VALUE;
    public static final int MIN32SIGNED = Integer.MIN_VALUE;
    public static final int MIN32UNSIGNED = 0;
    protected static ResourceBundle myResources = null;
    protected int min;
    protected int max;
    protected int deflt;
    protected int value;
    protected boolean rangeSet = false;

    public NumericInput() {
        this.addFocusListener(this);
    }

    public NumericInput(int n, int n2) {
        super(String.valueOf(n), n2);
        this.addFocusListener(this);
    }

    public NumericInput(int n) {
        super("", n);
        this.addFocusListener(this);
    }

    public NumericInput(int n, int n2, int n3, int n4, int n5) {
        this(n, n5);
        this.min = n2;
        this.max = n3;
        this.deflt = n4;
        this.rangeSet = true;
    }

    public NumericInput(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n, n4);
    }

    public NumericInput(int n, int n2, int n3) {
        this(n, n2, n3, n, Math.max((" " + n2).length(), (" " + n3).length()));
    }

    public boolean isValidValue(String string) {
        this.value = this.deflt;
        if ((string = string.trim()).length() == 0 || string.length() == 1 && string.charAt(0) == '-' && this.min < 0) {
            return true;
        }
        try {
            this.value = Integer.valueOf(string);
            if (this.rangeSet) {
                if (this.min <= 0 && this.max >= 0) {
                    return this.value >= this.min && this.value <= this.max;
                }
                if (this.max <= 0) {
                    return this.value >= this.min;
                }
                if (this.min >= 0) {
                    return this.value <= this.max;
                }
                return true;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isValidValue() {
        String string = this.getText().trim();
        if (string.length() == 0) {
            ((TextComponent)this).setText(NumericInput.messageText("noValue"));
            return false;
        }
        if (this.rangeSet) {
            try {
                this.value = Integer.valueOf(string);
                if (this.value < this.min || this.value > this.max) {
                    ((TextComponent)this).setText(NumericInput.messageText("valueOutOfRange"));
                    return false;
                }
            }
            catch (Exception exception) {}
        }
        if (!this.isValidValue(string)) {
            if (!string.equals(NumericInput.messageText("noValue")) && !string.equals(NumericInput.messageText("valueOutOfRange"))) {
                ((TextComponent)this).setText(NumericInput.messageText("nonNumericValue"));
            }
            return false;
        }
        return true;
    }

    public int numericValue() {
        if (this.isValidValue()) {
            return this.value;
        }
        return this.deflt;
    }

    public Object getValue() {
        return new Integer(this.numericValue());
    }

    public String toString() {
        System.out.println("NumericInput returning value: " + this.value);
        return String.valueOf(this.value);
    }

    public void setValue(Object object) {
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            this.value = n;
            ((TextComponent)this).setText(String.valueOf(this.value));
            this.isValidValue();
            return;
        }
        if (object instanceof SpecialValue) {
            SpecialValue specialValue = (SpecialValue)object;
            ((TextComponent)this).setText(specialValue.toString());
            return;
        }
        System.err.println("Error: Attempt to set NumericInput from " + object.getClass().getName());
    }

    public void setValue(String string) {
        try {
            this.value = Integer.parseInt(string);
            ((TextComponent)this).setText(string);
            this.isValidValue();
            return;
        }
        catch (NumberFormatException numberFormatException) {
            ((TextComponent)this).setText(string);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setMinMax(int n, int n2) {
        this.min = n;
        this.max = n2;
        this.rangeSet = true;
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.isValidValue();
    }

    protected static String messageText(String string) {
        try {
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("ibm.nways.jdm.eui.EuiErrorResources");
            }
            if (myResources == null) {
                return string;
            }
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }
}

